var a = false;

$(document).ready(function () {
    // Prevent navigation to disabled tabs
    $('.nav-tabs a[data-toggle="tab"]').on('click', function (e) {
        if ($(this).closest('li').hasClass('disabled')) {
            e.preventDefault();
            return false;
        }
    });

    // === PERSONAL INFO SUBMIT ===
    $('#btn_save').click(function () {
        if (a === true) return;

        var isValid = true;
        var firstInvalid = null;

        var requiredFields = [
            '#fac_Fname', '#fac_Mname', '#fac_Lname',
            '#fac_mailId', '#fac_mobileNo', '#Password', '#fkbranch_id'
        ];

        requiredFields.forEach(function (selector) {
            var input = $(selector);
            var value = input.val().trim();

            if (!value) {
                markInvalid(input);
                isValid = false;
                if (!firstInvalid) firstInvalid = input;
            } else {
                clearInvalid(input);
            }
        });

        // ✅ Gmail validation
        var email = $('#fac_mailId').val().trim();
        var gmailRegex = /^[a-zA-Z0-9._%+-]+@gmail\.com$/;

        if (!gmailRegex.test(email)) {
            markInvalid($('#fac_mailId'));
            isValid = false;
            if (!firstInvalid) firstInvalid = $('#fac_mailId');
        } else {
            clearInvalid($('#fac_mailId'));
        }

        // ❌ If not valid, stop
        if (!isValid && firstInvalid) {
            $('html, body').animate({ scrollTop: firstInvalid.offset().top - 100 }, 500);
            return;
        }

        // ✅ Proceed to submit
        savePersonalInfo();
    });

    // === INPUT/SELECT CHANGE HANDLER ===
    $('form').on('input change', 'input, textarea, select', function () {
        if ($(this).val().trim() !== '') {
            clearInvalid($(this));
        }
    });

    // === GENDER SELECT ===
    $('input[name="fkgender"]').on('change', function () {
        $('input[name="fkgender"]').removeClass('custom-invalid');
    });

    // === PREVIOUS STEP BUTTON ===
    $('.prev-step').click(function () {
        var $activeTab = $('.wizard .nav-tabs li.active');
        var $prevTab = $activeTab.prev('li:not(.disabled)');

        if ($prevTab.length > 0) {
            $activeTab.removeClass('active');
            $prevTab.addClass('active');
            $prevTab.find('a[data-toggle="tab"]').tab('show');
            $activeTab.removeClass('completed');
            updateProgressBar();
        }
    });

    // === AUTO UPDATE FULL NAME ===
    $('#fac_Fname, #fac_Mname, #fac_Lname').on('input', updateFullName);

    // === INSTITUTE & DEPARTMENT VALIDATION CLEAR ===
    $('#fkInstitute, #fkdep_id').on('change', function () {
        if ($(this).val() !== '') {
            clearInvalid($(this));
        }
    });

    // === OTHER FORM SUBMITS ===
    $('#btn_address_submit').click(function () {
        if (a === true) return;
        saveAddressInfo();
    });

    $('#btn_submit').click(function () {
        if (a === true) return;
        saveEducationInfo();
    });

    $('#btn_doc_submit').click(function () {
        if (a === true) return;
        saveDocumentInfo();
    });

    $('#btn_department_submit').click(function () {
        if (a === true) return;
        saveDepartmentInfo();
    });
});

// === HELPER FUNCTIONS ===
function markInvalid(input) {
    input.addClass('custom-invalid');

    // Bootstrap Select
    if (input.hasClass('selectpicker') || input.hasClass('select-single') || input.hasClass('js-states')) {
        input.parent().find('.dropdown-toggle').css('border', '1px solid red');
    }

    // Select2
    if (input.next('.select2').length) {
        input.next('.select2').find('.select2-selection').css('border', '1px solid red');
    }
}

function clearInvalid(input) {
    input.removeClass('custom-invalid');

    if (input.hasClass('selectpicker') || input.hasClass('select-single') || input.hasClass('js-states')) {
        input.parent().find('.dropdown-toggle').css('border', '');
    }

    if (input.next('.select2').length) {
        input.next('.select2').find('.select2-selection').css('border', '');
    }
}

function updateFullName() {
    var fname = $('#fac_Fname').val().trim();
    var mname = $('#fac_Mname').val().trim();
    var lname = $('#fac_Lname').val().trim();

    var fullName = [fname, mname, lname].filter(name => name.length > 0).join(' ');
    $('#fac_Fullname').val(fullName);
}

function updateProgressBar() {
    const totalSteps = $('.wizard .nav-tabs li').length;
    const completedSteps = $('.wizard .nav-tabs li.completed').length;

    const progressPercent = (completedSteps / totalSteps) * 100;
    $('#stepProgress').css('width', progressPercent + '%');
}

function enableNextStep(currentStepId, nextStepId) {
    const $currentTab = $('a[href="#' + currentStepId + '"]').closest('li');
    const $nextTab = $('a[href="#' + nextStepId + '"]').closest('li');

    $('.wizard .nav-tabs li').removeClass('active');

    $currentTab.removeClass('active').addClass('completed');
    $nextTab.removeClass('disabled').addClass('active');
    $nextTab.find('a').tab('show');

    updateProgressBar();
}

function parseResponse(response) {
    try {
        return JSON.parse(response);
    } catch (e) {
        Swal.fire('Oops!', 'Invalid server response.', 'error');
        return null;
    }
}


// === PROGRESS BAR UPDATE ===
function updateProgressBar() {
    const totalSteps = $('.wizard .nav-tabs li').length;
    const completedSteps = $('.wizard .nav-tabs li.completed').length;

    const progressPercent = (completedSteps / totalSteps) * 100;
    $('#stepProgress').css('width', progressPercent + '%');
}

// function updateProgressBar() {
//     const totalSteps = $('.wizard .nav-tabs li').length;
//     const completedSteps = $('.wizard .nav-tabs li.completed').length;

//     const progressPercent = (completedSteps / (totalSteps - 1)) * 100;
//     $('#stepProgress').css('width', progressPercent + '%');
// }

// === RESPONSE PARSER ===
function parseResponse(response) {
    try {
        return JSON.parse(response);
    } catch (e) {
        Swal.fire('Oops!', 'Invalid server response.', 'error');
        return null;
    }
}

function savePersonalInfo() {
    a = true;
    const Id = $('#fac_id').val();
    const base_path = $('#base_path').val();
    const form = $("#Form")[0];
    const formData = new FormData(form);

    const postUrl = (Id > 0)
        ? base_path + "admin/Faculty/updatePersonalInfo"
        : base_path + "admin/Faculty/insertPersonalInfo";

    $.ajax({
        url: postUrl,
        type: "POST",
        data: formData,
        processData: false,
        contentType: false,
        beforeSend: function () {
            $('#btn_save').prop('disabled', true).text('Loading...');
        },
        success: function (response) {
            $('#btn_save').prop('disabled', false).text('Submit');
            const res = parseResponse(response);

            if (!res) return;

            if (res.status === 'success') {
                $('#fac_id').val(res.fac_id);
                $('#fac_id_add').val(res.fac_id);
                $('#fac_id_doc').val(res.fac_id);

         Swal.fire({
  position: 'center',
  icon: 'success',
  title: '<strong>Success!</strong>',
  html: 'Personal Info Submitted Successfully',
  showConfirmButton: false,
  timer: 2000,
  customClass: {
    popup: 'custom-swal-popup',
    icon: 'custom-swal-icon',
    title: 'custom-swal-title',
    htmlContainer: 'custom-swal-text'
  }
})
                .then(() => {
                    enableNextStep('step1', 'step2'); // ✅ Move to next step only here
                });
            } else if (res.status === 'error' && res.message === 'Mobile number already exists.') {
                $('#fac_mobileNo').addClass('custom-invalid');
                Swal.fire('Duplicate Entry', res.message, 'warning');
            } else {
                Swal.fire('Oops!', res.message || 'Something went wrong.', 'error');
            }

            a = false;
        },
        error: function () {
            Swal.fire('Oops!', 'Failed to save Personal Info!', 'error');
            $('#btn_save').prop('disabled', false).text('Submit');
            a = false;
        }
    });
}

// === AJAX: ADDRESS INFO ===
function saveAddressInfo() {
    a = true;
    const base_path = $('#base_path').val();
    const form = $("#Form3")[0];
    const formData = new FormData(form);
    formData.append("fac_id", $('#fac_id_add').val());

    $.ajax({
        url: base_path + "admin/Faculty/insertAddressInfo",
        type: "POST",
        data: formData,
        processData: false,
        contentType: false,
        beforeSend: function () {
            $('#btn_address_submit').prop('disabled', true).text('Loading...');
        },
        success: function (response) {
            $('#btn_address_submit').prop('disabled', false).text('Submit');
            const res = parseResponse(response);
            if (!res) return;

            if (res.status === 'success') {

         Swal.fire({
  position: 'center',
  icon: 'success',
  title: '<strong>Success!</strong>',
  html: 'Address Info Submitted Successfully',
  showConfirmButton: false,
  timer: 2000,
  customClass: {
    popup: 'custom-swal-popup',
    icon: 'custom-swal-icon',
    title: 'custom-swal-title',
    htmlContainer: 'custom-swal-text'
  }
})                .then(() => {
                    enableNextStep('step2', 'step3');
                });
            } else {
                Swal.fire('Oops!', res.message || 'Update failed.', 'error');
            }

            a = false;
        },
        error: function () {
            Swal.fire('Oops!', 'Failed to save Address Info!', 'error');
            $('#btn_address_submit').prop('disabled', false).text('Submit');
            a = false;
        }
    });
}

// === AJAX: EDUCATION INFO ===
function saveEducationInfo() {
    a = true;
    const base_path = $('#base_path').val();
    const form = $("#Form1")[0];
    const formData = new FormData(form);

    $.ajax({
        url: base_path + "admin/Faculty/insertEducationInfo",
        type: "POST",
        data: formData,
        processData: false,
        contentType: false,
        beforeSend: function () {
            $('#btn_submit').prop('disabled', true).text('Loading...');
        },
        success: function (response) {
            $('#btn_submit').prop('disabled', false).text('Submit');

         Swal.fire({
  position: 'center',
  icon: 'success',
  title: '<strong>Success!</strong>',
  html: 'Education Info Submitted Successfully',
  showConfirmButton: false,
  timer: 2000,
  customClass: {
    popup: 'custom-swal-popup',
    icon: 'custom-swal-icon',
    title: 'custom-swal-title',
    htmlContainer: 'custom-swal-text'
  }
})            .then(() => {
                enableNextStep('step3', 'step4');
            });
            a = false;
        },
        error: function () {
            Swal.fire('Oops!', 'Failed to save Education Info!', 'error');
            $('#btn_submit').prop('disabled', false).text('Submit');
            a = false;
        }
    });
}

// === AJAX: DOCUMENT INFO ===
function saveDocumentInfo() {
    a = true;
    const base_path = $('#base_path').val();
    const form = $("#Form2")[0];
    const formData = new FormData(form);
    formData.append("fac_id", $('#fac_id_doc').val());

    $.ajax({
        url: base_path + "admin/Faculty/insertDocumentInfo",
        type: "POST",
        data: formData,
        processData: false,
        contentType: false,
        beforeSend: function () {
            $('#btn_doc_submit').prop('disabled', true).text('Loading...');
        },
        success: function (response) {
            $('#btn_doc_submit').prop('disabled', false).text('Submit');

         Swal.fire({
  position: 'center',
  icon: 'success',
  title: '<strong>Success!</strong>',
  html: 'Document Info Submitted Successfully',
  showConfirmButton: false,
  timer: 2000,
  customClass: {
    popup: 'custom-swal-popup',
    icon: 'custom-swal-icon',
    title: 'custom-swal-title',
    htmlContainer: 'custom-swal-text'
  }
})            .then(() => {
                enableNextStep('step4', 'step5');
            });
            a = false;
        },
        error: function () {
            Swal.fire('Oops!', 'Failed to save Document Info!', 'error');
            $('#btn_doc_submit').prop('disabled', false).text('Submit');
            a = false;
        }
    });
}


function saveDepartmentInfo() {
    a = true;
    const base_path = $('#base_path').val();
    const form = $("#Form4")[0];
    const formData = new FormData(form);
    formData.append("fac_id", $('#fac_id').val());

    var isValid = true;
    var firstInvalid = null;

    var requiredFields = ['#fkInstitute', '#fkdep_id'];
    requiredFields.forEach(function (selector) {
        var input = $(selector);
        if (!input.val() || input.val() === "") {
            markInvalid(input);
            isValid = false;
            if (!firstInvalid) firstInvalid = input;
        } else {
            clearInvalid(input);
        }
    });

    if (!isValid && firstInvalid) {
        $('html, body').animate({ scrollTop: firstInvalid.offset().top - 100 }, 500);
        a = false;
        return;
    }

    $.ajax({
        url: base_path + "admin/Faculty/insertDepartmentInfo",
        type: "POST",
        data: formData,
        processData: false,
        contentType: false,
        beforeSend: function () {
            $('#btn_department_submit').prop('disabled', true).text('Loading...');
        },
        success: function (response) {
            $('#btn_department_submit').prop('disabled', false).text('Save and continue');
            const res = parseResponse(response);
            if (!res) return;

            if (res.status === 'success') {

         Swal.fire({
  position: 'center',
  icon: 'success',
  title: '<strong>Success!</strong>',
  html: 'Department Info Submitted Successfully',
  showConfirmButton: false,
  timer: 2000,
  customClass: {
    popup: 'custom-swal-popup',
    icon: 'custom-swal-icon',
    title: 'custom-swal-title',
    htmlContainer: 'custom-swal-text'
  }
})                .then(() => {
                    const $finalTab = $('a[href="#step5"]').closest('li');
                    $finalTab.addClass('completed final-step');
                    updateProgressBar();
                    window.location.href = base_path + "admin/Faculty/index";
                });
            } else {
                Swal.fire('Oops!', res.message || 'Update failed.', 'error');
            }

            a = false;
        },
        error: function () {
            Swal.fire('Oops!', 'Failed to save Department Info!', 'error');
            $('#btn_department_submit').prop('disabled', false).text('Save and continue');
            a = false;
        }
    });
}


